<?php
// Start output buffering
ob_start();
?>

<div class="d-flex flex-row justify-content-between mb-3">
    <h3 class="fh2 fmon">My Videos</h3>
    <a href="<?= base_url('dashboard/workout-plans') ?>" class="btn btn-dark">Upload Video</a>
</div>

<ul class="nav nav-tabs gap-2" id="myTab" role="tablist">
    <!-- All Category Tab -->
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="all-category-tab" data-bs-toggle="tab" data-bs-target="#all-category"
            type="button" role="tab" aria-controls="all-category" aria-selected="true">All Category</button>
    </li>

    <!-- Dynamic workout type tabs -->
    <?php if (!empty($workoutTypes)):
        $maxVisible = 5; // show only first 5 tabs
    ?>
        <?php foreach ($workoutTypes as $index => $type):
            $typeName = is_array($type) && isset($type['name']) ? $type['name'] : (is_string($type) ? $type : '');
            $tabId = strtolower(str_replace(' ', '-', $typeName));
            $hiddenClass = ($index >= $maxVisible) ? 'd-none extra-tab' : '';
        ?>
            <li class="nav-item <?= $hiddenClass ?>" role="presentation">
                <button class="nav-link" id="<?= $tabId ?>-tab" data-bs-toggle="tab" data-bs-target="#<?= $tabId ?>"
                    type="button" role="tab" aria-controls="<?= $tabId ?>" aria-selected="false">
                    <?= htmlspecialchars($typeName) ?>
                </button>
            </li>
        <?php endforeach; ?>

        <?php if (count($workoutTypes) > $maxVisible): ?>
            <li class="nav-item">
                <button class="nav-link" id="toggle-tabs-btn" type="button">
                    More
                </button>
            </li>
        <?php endif; ?>
    <?php endif; ?>
</ul>

<div class="tab-content" id="myTabContent">
    <!-- All Category Tab -->
    <div class="tab-pane fade show active" id="all-category" role="tabpanel" aria-labelledby="all-category-tab">
        <div class="row mt-3">
            <?php if (!empty($workoutPlans)): ?>
                <?php foreach ($workoutPlans as $plan):
                    $planType = is_array($plan['type']) ? implode(', ', $plan['type']) : $plan['type'];
                ?>
                    <div class="col-md-4 mb-3">
                        <div class="profileCard d-flex flex-row" style="cursor: pointer;"
                            onclick="window.location.href='<?= base_url('workout/subworkout/' . $plan['id']) ?>'">
                            <div class="card-body p-2">
                                <h5 class="card-title"><?= htmlspecialchars($plan['title']) ?></h5>
                                <p class="card-text"><?= htmlspecialchars($planType) ?></p>
                                <div class="d-flex align-items-center gap-2">
                                    <p class="card-text ctext px-2 py-1 m-0">
                                        <small class="text-muted">
                                            <img src="<?= base_url('assets/images/megaIcons/pause.png') ?>" alt="">
                                            <?= isset($plan['subWorkoutCount']) ? htmlspecialchars($plan['subWorkoutCount']) : '0' ?>
                                            Videos
                                        </small>
                                    </p>
                                    <p class="card-text ctext px-2 py-1 m-0">
                                        <small class="text-muted">
                                            <img src="<?= base_url('assets/images/megaIcons/dollr.png') ?>" alt="">
                                            <?= '$' . number_format($plan['price'] ?? 0, 2) ?>
                                        </small>
                                    </p>
                                </div>
                            </div>
                            <img src="<?= !empty($plan['thumbnail']) ? htmlspecialchars($plan['thumbnail']) : base_url('dashboard-assets/images/img/Mask.png') ?>"
                                class="pcImageMyVideos" alt="<?= htmlspecialchars($plan['title']) ?>"
                                style="object-fit: cover; border-radius: 0 10px 10px 0; width: 140px; height: 140px;">
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-muted">No workout plans available.</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Dynamic workout type tab content -->
    <?php if (!empty($workoutTypes)): ?>
        <?php foreach ($workoutTypes as $type):
            $typeStr = is_array($type) ? implode('-', $type) : $type;
            $tabId = strtolower(str_replace(' ', '-', $typeStr));
        ?>
            <div class="tab-pane fade" id="<?= $tabId ?>" role="tabpanel" aria-labelledby="<?= $tabId ?>-tab">
                <div class="row mt-3">
                    <?php
                    // Filter workoutPlans for this type
                    $filteredPlans = array_filter($workoutPlans, function ($p) use ($type) {
                        $planTypes = is_array($p['type']) ? $p['type'] : [$p['type']];
                        return in_array($type, $planTypes);
                    });

                    if (!empty($filteredPlans)):
                        foreach ($filteredPlans as $plan):
                            $planType = is_array($plan['type']) ? implode(', ', $plan['type']) : $plan['type'];
                    ?>
                            <div class="col-md-4 mb-3">
                                <div class="profileCard d-flex flex-row" style="cursor: pointer;"
                                    onclick="window.location.href='<?= base_url('workout/subworkout/' . $plan['id']) ?>'">
                                    <div class="card-body p-2">
                                        <h5 class="card-title"><?= htmlspecialchars($plan['title']) ?></h5>
                                        <p class="card-text"><?= htmlspecialchars($planType) ?></p>
                                        <div class="d-flex align-items-center gap-2">
                                            <p class="card-text ctext px-2 py-1 m-0">
                                                <small class="text-muted">
                                                    <img src="<?= base_url('assets/images/megaIcons/pause.png') ?>" alt="">
                                                    <?= isset($plan['subWorkoutCount']) ? htmlspecialchars($plan['subWorkoutCount']) : '0' ?>
                                                    Videos
                                                </small>
                                            </p>
                                            <p class="card-text ctext px-2 py-1 m-0">
                                                <small class="text-muted">
                                                    <img src="<?= base_url('assets/images/megaIcons/dollr.png') ?>" alt="">
                                                    <?= '$' . number_format($plan['price'] ?? 0, 2) ?>
                                                </small>
                                            </p>
                                        </div>
                                    </div>
                                    <img src="<?= !empty($plan['thumbnail']) ? htmlspecialchars($plan['thumbnail']) : base_url('dashboard-assets/images/img/Mask.png') ?>"
                                        class="pcImageMyVideos" alt="<?= htmlspecialchars($plan['title']) ?>"
                                        style="object-fit: cover; border-radius: 0 10px 10px 0; width: 140px; height: 140px;">
                                </div>
                            </div>
                    <?php
                        endforeach;
                    else:
                        echo '<p class="text-muted">No plans available for this category.</p>';
                    endif;
                    ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php
// End buffering and capture content
$content = ob_get_clean();

// Load layout and pass content
$this->load->view('layouts/app', ['content' => $content]);
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const toggleBtn = document.getElementById('toggle-tabs-btn');
        if (!toggleBtn) return;

        let expanded = false;

        toggleBtn.addEventListener('click', function() {
            const hiddenTabs = document.querySelectorAll('.extra-tab');

            if (!expanded) {
                // Show extra tabs
                hiddenTabs.forEach(tab => tab.classList.remove('d-none'));
                toggleBtn.textContent = 'See Less';
            } else {
                // Hide extra tabs
                hiddenTabs.forEach(tab => tab.classList.add('d-none'));
                toggleBtn.textContent = 'More';
            }

            expanded = !expanded;
        });
    });
</script>
<style>
    #toggle-tabs-btn {
        background-color: #28a745;
        /* green */
        color: #fff;
        border-radius: 5px;
        padding: 6px 12px;
    }

    #toggle-tabs-btn:hover {
        background-color: #218838;
        /* darker green on hover */
        color: #fff;
    }
</style>